<?php

namespace Wycan;

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

class Elementor_Visibility_Scheduler {

    private static $_instance = null;

    public static function instance() {
        if ( is_null( self::$_instance ) ) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }

    public function __construct() {
        add_action( 'init', [ $this, 'init' ] );
        add_action( 'elementor/element/after_section_end', [ $this, 'register_controls' ], 10, 3 );
    }

    public function init() {
        // Hooks to handle rendering
        add_filter( 'elementor/frontend/section/should_render', [ $this, 'should_render' ], 10, 2 );
        add_filter( 'elementor/frontend/column/should_render', [ $this, 'should_render' ], 10, 2 );
        add_filter( 'elementor/frontend/container/should_render', [ $this, 'should_render' ], 10, 2 );
        add_filter( 'elementor/frontend/widget/should_render', [ $this, 'should_render' ], 10, 2 );
    }

    public function register_controls( $element, $section_id, $args ) {
        $element_type = $element->get_name();

        // Add controls to sections, columns, and containers
        if ( 'section' === $element_type || 'column' === $element_type || 'container' === $element_type ) {
            $this->add_visibility_controls( $element, \Elementor\Controls_Manager::TAB_LAYOUT );
        }

        // Add controls to widgets
        if ( 'common' === $element_type ) {
            $this->add_visibility_controls( $element, \Elementor\Controls_Manager::TAB_CONTENT );
        }
    }

    private function add_visibility_controls( $element, $tab ) {
        if ( ! $element->get_controls( 'visibility_action' ) ) {
            $element->start_controls_section(
                'section_visibility_scheduler',
                [
                    'label' => __( 'Visibility Scheduler', 'elementor-visibility-scheduler' ),
                    'tab' => $tab,
                ]
            );

            $element->add_control(
                'visibility_action',
                [
                    'label' => __( 'Visibility Action', 'elementor-visibility-scheduler' ),
                    'type' => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        '' => __( 'Do Nothing', 'elementor-visibility-scheduler' ),
                        'show' => __( 'Show', 'elementor-visibility-scheduler' ),
                        'hide' => __( 'Hide', 'elementor-visibility-scheduler' ),
                    ],
                    'default' => '',
                ]
            );

            $element->add_control(
                'start_date',
                [
                    'label' => __( 'Start Date', 'elementor-visibility-scheduler' ),
                    'type' => \Elementor\Controls_Manager::DATE_TIME,
                    'condition' => [
                        'visibility_action!' => '',
                    ],
                ]
            );

            $element->add_control(
                'end_date',
                [
                    'label' => __( 'End Date', 'elementor-visibility-scheduler' ),
                    'type' => \Elementor\Controls_Manager::DATE_TIME,
                    'condition' => [
                        'visibility_action!' => '',
                    ],
                ]
            );

            $element->end_controls_section();
        }
    }

    public function should_render( $should_render, $element ) {
        $settings = $element->get_settings_for_display();

        if ( isset( $settings['visibility_action'] ) && $settings['visibility_action'] !== '' ) {
            $current_time = current_time('timestamp');
            $start_time = !empty($settings['start_date']) ? strtotime($settings['start_date']) : 0;
            $end_time = !empty($settings['end_date']) ? strtotime($settings['end_date']) : PHP_INT_MAX;

            if ( $settings['visibility_action'] === 'hide' && ($current_time >= $start_time && $current_time <= $end_time) ) {
                return false;
            }

            if ( $settings['visibility_action'] === 'show' && !($current_time >= $start_time && $current_time <= $end_time) ) {
                return false;
            }
        }

        return $should_render;
    }
}