<?php
/**
 * Plugin Name: Elementor Visibility Scheduler
 * Plugin URI: https://wycan.fr/
 * Description: A plugin to schedule the visibility of Elementor widgets or containers.
 * Version: 1.0
 * Author: Wycan
 * Author URI: https://wycan.fr/
 * Text Domain: elementor-visibility-scheduler
 */
 
if ( ! function_exists( 'evs_fs' ) ) {
    // Create a helper function for easy SDK access.
    function evs_fs() {
        global $evs_fs;

        if ( ! isset( $evs_fs ) ) {
            // Include Freemius SDK.
            require_once dirname(__FILE__) . '/freemius/start.php';

            $evs_fs = fs_dynamic_init( array(
                'id'                  => '16189',
                'slug'                => 'elementor-visibility-scheduler',
                'type'                => 'plugin',
                'public_key'          => 'pk_71237f1397add89fe70bfd06d6484',
                'is_premium'          => false,
                'has_addons'          => false,
                'has_paid_plans'      => false,
                'menu'                => array(
                    'account'        => false,
                    'support'        => false,
                ),
            ) );
        }

        return $evs_fs;
    }

    // Init Freemius.
    evs_fs();
    // Signal that SDK was initiated.
    do_action( 'evs_fs_loaded' );
}

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

// Load the plugin class
require_once( plugin_dir_path( __FILE__ ) . 'includes/class-elementor-visibility-scheduler.php' );

// Initialize the plugin
function evs_init() {
    \Wycan\Elementor_Visibility_Scheduler::instance();
}
add_action( 'plugins_loaded', 'evs_init' );
